unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Grids, DBGrids, StdCtrls;

type
  TForm1 = class(TForm)
    DBGrid1: TDBGrid;
    Table1: TTable;
    DataSource1: TDataSource;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1Addr1: TStringField;
    Table1LastInvoiceDate: TDateTimeField;
    CheckBox1: TCheckBox;
    procedure DBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure CheckBox1Click(Sender: TObject);
  private
    procedure DBGrid1DrawColumnCell1(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
  if (Column.FieldName = 'LastInvoiceDate') then
    with DBGrid1.Canvas do begin
      if Table1LastInvoiceDate.Value >= EncodeDate(1994,1,1) then
        Font.Color := clNavy
      else
        Font.Color := clRed;
      FillRect(Rect);
      TextOut(Rect.Left+2,Rect.Top+2,Column.Field.DisplayText);
    end;
end;

procedure TForm1.DBGrid1DrawColumnCell1(Sender: TObject; const Rect: TRect;
  DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
  if (Column.FieldName = 'LastInvoiceDate') then
    with DBGrid1.Canvas do begin
      if Table1LastInvoiceDate.Value >= EncodeDate(1994,1,1) then
        Font.Color := clNavy
      else
        Font.Color := clRed;
    end;
    DBGrid1.DefaultDrawDataCell(Rect,Column.Field,State);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  with DBGrid1 do
    if CheckBox1.Checked then begin
      DefaultDrawing := False;
      OnDrawColumnCell := DBGrid1DrawColumnCell1;
    end
    else begin
      DefaultDrawing := True;
      OnDrawColumnCell := DBGrid1DrawColumnCell;
    end;
end;

end.
